#!/usr/bin/env python2

import rospy
import time
from std_msgs.msg import Int32
from pynput import keyboard


class KeyboardDetector:
    def __init__(self):
        self.pub = rospy.Publisher('key_op', Int32, queue_size=10)
        rospy.init_node('keyboard_signal', anonymous=True)
        with keyboard.Listener(
            on_press=self.on_press,
            on_release=self.on_release) as listener:
            listener.join()

    def on_press(self, key):
        try:
            if key.char == 's':
                rt = Int32()
                rt.data = 1
                self.pub.publish(rt)
            if key.char == 'a':
                # TO DO
            if key.char == 'd':
                # TO DO
            if key.char == 'w':
                # TO DO
            if key.char == 'x':
                # TO DO
            
        except AttributeError:
            print('special key pressed: {0}'.format(
                key))

    def on_release(self, key):
        try:
            if key.char == 'r':
                # TO DO
            if key.char == 'e':
                # TO DO
                return False
        except AttributeError:
            print('special key pressed: {0}'.format(
                key))

if __name__ == '__main__':
    try:
        KeyboardDetector()
    except rospy.ROSInterruptException:
        pass
