//state definition
#define INIT 0
#define RUNNING 1
#define MAPPING 2
#define PATH_PLANNING 3
#define FINISH -1

#include <unistd.h>
#include <ros/ros.h>
#include <project2/rrtTree.h>
#include <tf/transform_datatypes.h>
#include <pwd.h>
#include <project2/pid.h>
#include <math.h>
#include <geometry_msgs/PoseWithCovarianceStamped.h>
#include <nav_msgs/Path.h>
#include <ackermann_msgs/AckermannDriveStamped.h>
#include "race/drive_param.h"

//map spec
cv::Mat map;
double res;
int map_y_range;
int map_x_range;
double map_origin_x;
double map_origin_y;
double world_x_min;
double world_x_max;
double world_y_min;
double world_y_max;

//TODO 1
//parameters students should adjust : K, margin, MaxStep
int margin = 6;
int K = 500;
double MaxStep = 1;
/////////

//way points
std::vector<point> waypoints;

//path
std::vector<traj> path_RRT;

//control
nav_msgs::Path visual_path;

//robot
point robot_pose;
race::drive_param cmd;

//FSM state
int state;

//function definition
void set_waypoints();
void generate_path_RRT();
void callback_state(geometry_msgs::PoseWithCovarianceStampedConstPtr msgs);
void setcmdvel(double v, double w);

int main(int argc, char** argv){
    ros::init(argc, argv, "rrt_main");
    ros::NodeHandle n;

    // Initialize topics
    ros::Publisher cmd_vel_pub = n.advertise<race::drive_param>("/drive_parameters",100); 
    ros::Publisher path_pub = n.advertise<nav_msgs::Path>("/rrt_path",100);
    
    ros::Subscriber robot_pose_sub = n.subscribe("/amcl_pose", 100, callback_state);
    printf("Initialize topics\n");

    // Load Map
/////////////////////////////////////////////// Temproary map for hardward setup. it will be modified on the actual challenge day
    char* user = getpwuid(getuid())->pw_name;
    map = cv::imread((std::string("/home/nvidia/") +
                      std::string("catkin_ws/src/challenge/src/final.pgm")).c_str(),CV_LOAD_IMAGE_GRAYSCALE);
//////////////////////////////////////////////////////////////////////////////////////

    cv::transpose(map,map);
    cv::flip(map,map,1);
    map_y_range = map.cols;
    map_x_range = map.rows;
    map_origin_x = map_x_range/2.0 - 0.5;
    map_origin_y = map_y_range/2.0 - 0.5;

/////////////////////////////////////////////// Also, these numbers will be modified on the actual challenge day
    world_x_min = -1.7;
    world_x_max = 2.2;
    world_y_min = -2.6;
    world_y_max = 3.3;
    res = 0.05;
//////////////////////////////////////////////////

    printf("Load map\n");


    if(! map.data )                              // Check for invalid input
    {
        printf("Could not open or find the image\n");
        return -1;
    }

    // Set Way Points
    set_waypoints();
    printf("Set way points\n");

    //initial_pose
    robot_pose.x= waypoints[0].x;
    robot_pose.y= waypoints[0].y;
    robot_pose.th= waypoints[0].th;


    // RRT
    generate_path_RRT();
    printf("Generate RRT\n");

    // FSM
    state = INIT;
    bool running = true;
    ros::Rate control_rate(60);

    while(running){
        switch (state) {
        case INIT: {
        printf("path size : %d\n", path_RRT.size());
            state = RUNNING;
        } break;

        case RUNNING: {
			/////don't remove this///////
		    visual_path.poses.resize(path_RRT.size());
            for(int i =0; i < path_RRT.size(); i++){
                visual_path.header.frame_id = "map";
		        visual_path.header.stamp = ros::Time::now();
		        visual_path.poses[i].pose.position.x = path_RRT[i].x;			
		        visual_path.poses[i].pose.position.y = path_RRT[i].y;
            }
			////////////////////////////
			while(ros::ok()) {
            	path_pub.publish(visual_path);
				/* TODO 2
				****Copy your code in final project main.cpp
				****Usage of cmd_vel_pub is slightly different in real rccars
				******Before: cmd.drive.speed = 0.5; cmd.drive.steering_angle = 0.4;
				******After : cmd.velociy = 0.5; cmd.angle = 0.4;
				******(but you can use setcmdvel() function same as before)
				****Also, the scales of the control inputs are different in gazebo and real rccar. 
				****You have to calibrate those numbers during hardware setup week.
				
				****please check the below instructions, and tune your control inputs roughly before hardware setup week
				****
				****cmd.velocity (the numbers does not mean **m/s!!)
                ****-> Each rc car have its own minimum velocity values (0.3 or 0.45 or 0.5). Take this into account and prepare for the hardware setup.
				****cmd.angle
				****-> max , min angle value are 1 (35 degree) and -1(-35 degree). You may need to normalize your PID ctrl value
			
			*/
			}
        } break;

        case FINISH: {
            setcmdvel(0,0);
            cmd_vel_pub.publish(cmd);
            running = false;
            ros::spinOnce();
            control_rate.sleep();
        } break;

        default: {
        } break;
        }
    }
    return 0;
}

void generate_path_RRT()
{
	/*TODO 3
	****copy your code in final project main.cpp
    ****delete tree->visualizeTree() and tree->visualizeTree(vec) */
	
}

void set_waypoints()
{
    point waypoint_candid[8];
    
    waypoint_candid[0].x = -1.05;
    waypoint_candid[0].y = 2.7;
    waypoint_candid[0].th = -3.141592/4;
    waypoint_candid[1].x = 0.1;
    waypoint_candid[1].y = -0.93;
    waypoint_candid[2].x = 1.7;
    waypoint_candid[2].y = -1.95;
 
    int order[] = {0,1,2};
    int order_size = 2;

    for(int i = 0; i < order_size; i++){
        waypoints.push_back(waypoint_candid[order[i]]);
    }
}

void callback_state(geometry_msgs::PoseWithCovarianceStampedConstPtr msgs){
    robot_pose.x = msgs->pose.pose.position.x;
    robot_pose.y = msgs->pose.pose.position.y;
    robot_pose.th = tf::getYaw(msgs->pose.pose.orientation);
}

void setcmdvel(double vel, double deg){
    cmd.velocity = vel;
    cmd.angle = deg;
}
